/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.domain.enums;

import java.util.HashMap;
import java.util.Map;

public enum ApiPolicyType {
    ApiSubscribe,
    ApiAccessAllow,
    ApiAccessDeny,
    ApiAuthSign,
    ApiAuthBase;

    public static final String API_ACCESS_ALLOW_ID = "APIAllowlist";
    private static final Map<String, ApiPolicyType> SOLES;

    public static boolean isSole(String method) {
        return method != null && SOLES.containsKey(method);
    }

    public static boolean isApi(String name) {
        ApiPolicyType apiPolicyType = ApiPolicyType.valueOfOrNull(name);
        return apiPolicyType == ApiAccessAllow || apiPolicyType == ApiAccessDeny || apiPolicyType == ApiAuthSign || apiPolicyType == ApiAuthBase;
    }

    private static ApiPolicyType valueOfOrNull(String name) {
        for (ApiPolicyType value : ApiPolicyType.values()) {
            if (!value.name().equals(name)) continue;
            return value;
        }
        return null;
    }

    static {
        SOLES = new HashMap<String, ApiPolicyType>(3);
        SOLES.put(ApiAccessAllow.name(), ApiAccessAllow);
    }
}

