/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyCond;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.mapper.RamPolicyMapper;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamPolicyCrudServiceImpl
implements RamPolicyCrudService {
    @Autowired
    private RamPolicyMapper ramPolicyMapper;

    @Override
    public long insert(Policy data) {
        BaseUtils.setCreateFields(data);
        this.ramPolicyMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return this.ramPolicyMapper.deleteBySid(sid);
    }

    @Override
    public long update(Policy data) {
        BaseUtils.setModifyFields(data);
        this.ramPolicyMapper.update(data);
        return data.getSid();
    }

    @Override
    public Policy findBySid(long sid) {
        return this.ramPolicyMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Policy data) {
        return this.ramPolicyMapper.exists(data.getSid());
    }

    @Override
    public List<PolicyVO> findByCond(PolicyCond data) {
        return this.ramPolicyMapper.findByCond(data);
    }

    @Override
    public PageData<PolicyVO> findByPage(PolicyCond page) {
        long total = this.ramPolicyMapper.countByPage(page);
        if (total == 0L) {
            return PageData.empty();
        }
        List<PolicyVO> paths = this.ramPolicyMapper.findByPage(page, Pageable.ofPage(page));
        return PageData.data(total, paths);
    }

    @Override
    public Policy findByAppAndId(String app, String policyId) {
        return this.ramPolicyMapper.findByAppAndId(app, policyId);
    }
}

