/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.core.impl;

import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.console.policy.PolicyGrantVO;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.core.RamBaseGroupService;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.service.executor.RamGroupGrantExecutor;
import com.digiwin.dap.middle.ram.service.executor.RamGroupPolicyExecutor;
import com.digiwin.dap.middle.ram.support.MappingInfoRegistry;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RamBaseGroupServiceImpl
implements RamBaseGroupService {
    @Autowired
    private RamCoreService ramCoreService;
    @Autowired
    private RamGroupGrantExecutor ramGroupGrantExecutor;
    @Autowired
    private RamGroupPolicyExecutor ramGroupPolicyExecutor;
    @Autowired
    private MappingInfoRegistry mappingInfoRegistry;

    @Override
    public MappingRegistry getPattern(String app, String appId, String policyType) {
        List<PatternVO> patterns = this.ramGroupPolicyExecutor.findGroupRouteByPolicyType(app, policyType);
        return new MappingRegistry(patterns, this.mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public Statement getPolicyRoute(String app, String appId, String policyType, String targetType, String targetId) {
        ArrayList<PatternVO> routes = new ArrayList<PatternVO>();
        List<String> policyIds = this.ramCoreService.findPolicyId(app, policyType, targetType, targetId);
        for (String policyId : policyIds) {
            routes.addAll(this.ramGroupPolicyExecutor.findGroupRouteByPolicyId(app, policyId));
        }
        return new Statement(routes, this.mappingInfoRegistry.getMappingRegistry(appId));
    }

    @Override
    public List<PolicyGrantVO> findGrantsByRoute(String app, String targetType, String method, String path) {
        List<Long> groupSids = this.ramGroupPolicyExecutor.findGroupSidByRoute(app, method, path);
        List<String> policyIds = groupSids.stream().map(p -> "api:group:" + p).collect(Collectors.toList());
        return this.findGrantTargetByPolicyIds(app, targetType, policyIds);
    }

    private List<PolicyGrantVO> findGrantTargetByPolicyIds(String app, String targetType, List<String> policyIds) {
        return policyIds.stream().map(policyId -> this.ramGroupGrantExecutor.findPolicyGrantByPolicyId(app, targetType, (String)policyId)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean existGrant(String app, String targetType, String policyId, String targetId) {
        PolicyGrantVO grant = this.ramGroupGrantExecutor.findGrantByPolicyIdAndTargetId(app, targetType, policyId, targetId);
        return grant != null;
    }
}

