/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.cache;

public class CacheKeyBuilder {
    private static final String RAM = "ram";
    private static final String COLON = ":";
    private static final String GRANT = "grant";
    private static final String POLICY = "policy";
    private static final String ROUTE = "route";
    private static final String TARGET = "target";
    private static final String GROUP = "group";

    public static String getPolicyByTargetId(String prefix, String app, String targetType, String targetId) {
        return String.join((CharSequence)COLON, prefix, CacheKeyBuilder.getPolicyByTargetId(app, targetType, targetId));
    }

    public static String getPolicyByTargetId(String app, String targetType, String targetId) {
        return String.join((CharSequence)COLON, RAM, GRANT, POLICY, app, targetType, targetId);
    }

    public static String getRouteByPolicyId(String prefix, String app, String policyId) {
        return String.join((CharSequence)COLON, prefix, CacheKeyBuilder.getRouteByPolicyId(app, policyId));
    }

    public static String getRouteByPolicyId(String app, String policyId) {
        return String.join((CharSequence)COLON, RAM, POLICY, app, policyId);
    }

    public static String getRouteByPolicyType(String prefix, String app, String policyType) {
        return String.join((CharSequence)COLON, prefix, CacheKeyBuilder.getRouteByPolicyType(app, policyType));
    }

    public static String getRouteByPolicyType(String app, String policyType) {
        return String.join((CharSequence)COLON, RAM, POLICY, app, policyType);
    }

    public static String getPolicyByPath(String prefix, String app, String method, String path) {
        return String.join((CharSequence)COLON, prefix, CacheKeyBuilder.getPolicyByPath(app, method, path));
    }

    public static String getPolicyByPath(String app, String method, String path) {
        return String.join((CharSequence)COLON, RAM, POLICY, app, "{" + method + " " + path + "}");
    }

    public static String getRouteByApp(String prefix, String appId) {
        return String.join((CharSequence)COLON, prefix, CacheKeyBuilder.getRouteByApp(appId));
    }

    public static String getRouteByApp(String appId) {
        return String.join((CharSequence)COLON, RAM, ROUTE, appId);
    }

    public static String getPolicyGrantByPolicyId(String app, String targetType, String policyId) {
        return String.join((CharSequence)COLON, GRANT, TARGET, app, targetType, policyId);
    }

    public static String getGrantByPolicyIdAndTargetId(String app, String targetType, String policyId, String targetId) {
        return String.join((CharSequence)COLON, GRANT, TARGET, app, targetType, policyId, targetId);
    }

    public static String getGroupRouteByPolicyType(String app, String policyType) {
        return String.join((CharSequence)COLON, POLICY, app, policyType);
    }

    public static String getGroupRouteByPolicyId(String app, String policyId) {
        return String.join((CharSequence)COLON, POLICY, app, policyId);
    }

    public static String getGroupSidByRoute(String app, String method, String path) {
        return String.join((CharSequence)COLON, GROUP, app, "{" + method + " " + path + "}");
    }
}

