/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.iam;

import com.digiwin.dap.middle.ram.support.RamCacheSupport;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.StdData;
import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DefaultRamCacheSupport
implements RamCacheSupport {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRamCacheSupport.class);
    @Autowired
    private DapEnv dapEnv;
    @Resource(name="dapRetryRestTemplate")
    private RestTemplate retryRestTemplate;

    @Override
    public List<String> getSysByPlatformId(String platformId) {
        return this.getAppIds(platformId, true);
    }

    @Override
    public List<String> getPlatformSysBySysId(String sysId) {
        return this.getAppIds(sysId, false);
    }

    private List<String> getAppIds(String sysId, boolean platform) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            requestBody.put("id", sysId);
            requestBody.put("platform", platform);
            HttpEntity httpEntity = new HttpEntity(requestBody, (MultiValueMap)headers);
            String uri = this.dapEnv.getIamUri() + "/api/iam/v2/sys/platform/ids";
            ResponseEntity result = this.retryRestTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<List<String>>>(this){}, new Object[0]);
            return (List)((StdData)result.getBody()).getData();
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5e94\u6216\u7528\u5e73\u53f0", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

