/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.security.auth;

import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.auth.handler.BeforeAuthPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.auth.handler.DoAuthResultPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.auth.handler.NoAuthAppAuthPolicyHandler;
import com.digiwin.dap.middle.ram.support.security.auth.handler.NoAuthUserAuthPolicyHandler;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public class AuthPolicyHandlerComposite
extends AuthPolicyHandler {
    private final List<AuthPolicyHandler> handlers = new ArrayList<AuthPolicyHandler>(5);

    public AuthPolicyHandlerComposite(RamCoreService ramCoreService, RamHandlerSupport ramHandlerSupport) {
        this.handlers.add(new BeforeAuthPolicyHandler(ramCoreService));
        this.handlers.add(new DoAuthResultPolicyHandler(ramHandlerSupport));
        this.handlers.add(new NoAuthAppAuthPolicyHandler(ramCoreService));
        this.handlers.add(new NoAuthUserAuthPolicyHandler(ramCoreService));
        AnnotationAwareOrderComparator.sort(this.handlers);
    }

    @Override
    public boolean supports(AuthType authType) {
        return false;
    }

    @Override
    public AuthResult process(AuthResult authResult, AccessUser request) {
        for (AuthPolicyHandler handler : this.handlers) {
            if (!handler.supports(authResult.getAuthType())) continue;
            AuthResult temp = handler.process(authResult, request);
            if (temp.getAuthType() == AuthType.AppOk) {
                return temp;
            }
            authResult = temp;
        }
        return authResult;
    }

    @Override
    public AccessResult handle(AccessUser request) {
        AuthResult authResult = this.process(AuthResult.of(), request);
        AuthType.checkAuthResult((AuthType)authResult.getAuthType(), (String)request.getUserId(), (String)request.getTenantId(), (String)request.getSysId());
        return AccessResult.next();
    }
}

