/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.web;

import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.support.web.condition.MappingInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UrlPathHelper;

public class MappingRegistry {
    private final Map<MappingInfo, PatternVO> registry = new HashMap<MappingInfo, PatternVO>();
    private final MultiValueMap<String, MappingInfo> urlLookup = new LinkedMultiValueMap();
    private final Map<MappingInfo, PatternVO> mappingLookup = new LinkedHashMap<MappingInfo, PatternVO>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private MappingInfo.BuilderConfiguration config = new MappingInfo.BuilderConfiguration();

    public MappingRegistry() {
        this.config.setUrlPathHelper(MappingInfo.BuilderConfiguration.defaultInstance);
        this.config.setPathMatcher((PathMatcher)new AntPathMatcher());
    }

    public MappingRegistry(List<PatternVO> mappings, MappingRegistry mappingRegistry) {
        this.config = mappingRegistry.getConfig();
        for (PatternVO handler : mappings) {
            MappingInfo.Builder builder = MappingInfo.paths(handler.getPath()).methods(MappingInfo.getMethod(handler.getMethod()));
            MappingInfo mapping = builder.options(mappingRegistry.getConfig()).build();
            if (mappingRegistry.getPathMatcher().isPattern(handler.getPath())) {
                if (!mappingRegistry.getMappingLookup().containsKey(mapping)) {
                    mappingRegistry.register(mapping, handler);
                }
                this.mappingLookup.put(mapping, handler);
            } else {
                this.urlLookup.add((Object)handler.getPath(), (Object)mapping);
            }
            this.registry.put(mapping, handler);
        }
    }

    public void register(MappingInfo mapping, PatternVO handler) {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.getPathMatcher().isPattern(handler.getPath())) {
                this.mappingLookup.put(mapping, handler);
            } else {
                this.urlLookup.add((Object)handler.getPath(), (Object)mapping);
            }
            this.registry.put(mapping, handler);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Map<MappingInfo, PatternVO> getRegistry() {
        return this.registry;
    }

    public Map<MappingInfo, PatternVO> getMappingLookup() {
        return this.mappingLookup;
    }

    public List<MappingInfo> getMappingsByUrl(String urlPath) {
        return (List)this.urlLookup.get((Object)urlPath);
    }

    public boolean isEmpty() {
        return this.urlLookup.isEmpty() && this.mappingLookup.isEmpty();
    }

    public MappingInfo.BuilderConfiguration getConfig() {
        return this.config;
    }

    public PathMatcher getPathMatcher() {
        return this.config.getPathMatcher();
    }

    public UrlPathHelper getUrlPathHelper() {
        return this.config.getUrlPathHelper();
    }
}

