package com.digiwin.dap.middle.ram.domain.console.policy;

import com.digiwin.dap.middle.ram.constant.RamI18nError;
import com.digiwin.dap.middle.ram.domain.access.ApiAccessUser;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middleware.exception.BusinessException;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * 策略对应授权
 *
 * @author fobgochod
 * @since 4.36.5
 */
public class PolicyGrantVO {

    /**
     * {@link TargetType}
     */
    private String type;
    private String id;
    private LocalDateTime attachDate;
    private LocalDateTime expiredDate;

    /**
     * 检查目标租户是否有授权
     *
     * @param grants  路由的
     * @param request 请求信息
     */
    public static void checkValidGrant(List<PolicyGrantVO> grants, ApiAccessUser request) {
        Optional<PolicyGrantVO> optional = grants.stream().filter(p -> Objects.equals(p.getId(), request.getDevTenantId())).findFirst();
        if (optional.isPresent()) {
            if (LocalDateTime.now().isAfter(optional.get().getExpiredDate())) {
                throw new BusinessException(RamI18nError.API_SUBSCRIBE_EXPIRED, new Object[]{request.getDevTenantId()});
            }
        } else {
            throw new BusinessException(RamI18nError.API_SUBSCRIBE_NONE, new Object[]{request.getDevTenantId(), request.getMethod(), request.getPath()});
        }
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LocalDateTime getAttachDate() {
        return attachDate;
    }

    public void setAttachDate(LocalDateTime attachDate) {
        this.attachDate = attachDate;
    }

    public LocalDateTime getExpiredDate() {
        return expiredDate;
    }

    public void setExpiredDate(LocalDateTime expiredDate) {
        this.expiredDate = expiredDate;
    }

    @Override
    public String toString() {
        return id + "[" + expiredDate + "]";
    }
}
