package com.digiwin.dap.middle.ram.domain.enums;

/**
 * 策略分类
 *
 * @author fobgochod
 * @see PolicyCategory
 * @since 4.36.3
 */
public enum ApiPolicyCategory {

    /**
     * 3-API中心-访问控制策略
     */
    ApiAccess(3),
    /**
     * 4-API中心-签名认证策略
     */
    ApiAuth(4),
    /**
     * 5-API中心-租户订阅
     */
    ApiSubscribe(5),
    ;

    private final int code;

    ApiPolicyCategory(int code) {
        this.code = code;
    }

    public int getCode() {
        return code;
    }
}
