package com.digiwin.dap.middle.ram.service.base;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.vo.PolicyRouteVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.RouteVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyRouteCond;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;

import java.util.List;

public interface RamPolicyRouteCrudService extends RamBaseService<PolicyRoute> {

    int deleteByPolicySid(long policySid);

    int deleteByPolicySidAndRouteSid(long policySid, long routeSid);

    List<PolicyVO> findByRouteSid(long routeSid);

    List<RouteVO> findByPolicySid(long policySid);

    PageData<PolicyRouteVO> findByPage(PolicyRouteCond page);
}
