package com.digiwin.dap.middle.ram.service.executor.redis;

import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.service.executor.RamGrantExecutor;
import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class RamGrantRedisCacheExecutor implements RamGrantExecutor {

    private final RamGrantExecutor delegate;

    public RamGrantRedisCacheExecutor(RamGrantExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getPolicyByTargetId(#app, #targetType, #targetId)")
    @Override
    public List<PolicyVO> findPolicyByTargetId(String app, String targetType, String targetId) {
        return delegate.findPolicyByTargetId(app, targetType, targetId);
    }
}
