package com.digiwin.dap.middle.ram.support.security.path.handler;

import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessInfo;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.TargetHandler;
import com.digiwin.dap.middle.ram.support.security.TargetChain;
import com.digiwin.dap.middle.ram.support.security.path.PathPolicyHandler;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import org.springframework.core.annotation.Order;

/**
 * 功能权限，策略类型 {@link PolicyType#Base}
 * <p>
 * 系统策略和用户自定义策略，按照最小单元判定流程匹配 {@link ResultType}
 *
 * @author fobgochod
 */
@Order(300)
public class BasePathPolicyHandler extends PathPolicyHandler<AccessUser> implements TargetHandler<AccessInfo> {

    public BasePathPolicyHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public AccessResult handle(AccessUser request) {
        TargetChain<AccessInfo> chain = new TargetChain<>(this, TargetInfo.getTargets(request));
        return chain.doNextStep(request);
    }

    @Override
    public AccessResult handle(TargetType targetType, String targetId, AccessInfo request) {
        Statement statement = ramCoreService.getPolicyRoute(request.getApp(), PolicyType.Base.name(), targetType.name(), targetId);
        if (!statement.getDeny().isEmpty()) {
            PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getDeny());
            if (matched != null) {
                return AccessResult.deny(matched.getPolicyId());
            }
        }
        if (!statement.getAllow().isEmpty()) {
            PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow());
            if (matched != null) {
                return AccessResult.allow();
            }
        }
        return AccessResult.next();
    }
}
