/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.access.api.handler;

import com.digiwin.dap.middle.ram.constant.RamI18nError;
import com.digiwin.dap.middle.ram.domain.PolicyOrder;
import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.access.ApiAccessUser;
import com.digiwin.dap.middle.ram.domain.enums.ApiPolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.remote.DevInfoVO;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.access.api.RamApiPolicyHandler;
import com.digiwin.dap.middle.ram.service.core.RamBaseGroupService;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class RamAccessApiPolicyHandler
extends RamApiPolicyHandler
implements Ordered {
    private final RamHandlerSupport ramHandlerSupport;

    public RamAccessApiPolicyHandler(RamBaseGroupService baseGroupService, RamHandlerSupport ramHandlerSupport) {
        super(baseGroupService);
        this.ramHandlerSupport = ramHandlerSupport;
    }

    @Override
    public AccessResult handle(ApiAccessUser request) {
        if (request.getUserToken() == null || request.getAppToken() == null) {
            return AccessResult.allow();
        }
        boolean isGrant = this.ramBaseGroupService.existGrant(request.getApp(), TargetType.Sys.name(), "APIAllowlist", request.getSysId());
        if (isGrant) {
            return AccessResult.allow();
        }
        Statement denys = this.ramBaseGroupService.getPolicyRoute(request.getApp(), request.getAppId(), ApiPolicyType.ApiAccessDeny.name(), TargetType.Sys.name(), request.getSysId());
        PatternVO denyMatched = MatcherUtils.matches(request.getMethod(), request.getPath(), denys.getAllow());
        if (denyMatched != null) {
            throw new BusinessException((ErrorHandler)RamI18nError.API_POLICY_ACCESS_DENY, new Object[]{request.getSysId()});
        }
        DevInfoVO appDev = this.ramHandlerSupport.getDevTenant(request.getUserToken(), request.getSysId());
        request.setDevTenantId(appDev.getTenantId());
        return AccessResult.next();
    }

    public int getOrder() {
        return PolicyOrder.API_ACCESS.order();
    }
}

