/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.iam;

import com.digiwin.dap.middle.ram.domain.remote.AppAuthResult;
import com.digiwin.dap.middle.ram.domain.remote.DevInfoVO;
import com.digiwin.dap.middle.ram.domain.sign.VerifyLog;
import com.digiwin.dap.middleware.cache.RedisUtils;
import java.time.Duration;
import java.time.LocalDateTime;

public class RedisCache {
    private static final String TENANT_USER_SYS_AUTH = "cac:tenant:user:auth:%s::%s::%s";
    public static final String SOP_PLATFORM_PREFIX = "entity:sysonplatform:platform:";
    public static final String SOP_SYS_PREFIX = "entity:sysonplatform:sys:";
    public static final String ISV_DEV_TENANT_ID = "ram:api:subscribe:dev:%s";
    public static final String ISV_CREDENTIAL = "entity:isv:credential:key:%s";
    public static final String ISV_CREDENTIAL_RECORD = "ram:api:sign:verify:%s:%s";

    public static AppAuthResult getAuthResult(String tenantId, String userId, String sysId) {
        String cacAuthKey = String.format(TENANT_USER_SYS_AUTH, tenantId, userId, sysId);
        return (AppAuthResult)((Object)RedisUtils.get((Object)cacAuthKey, AppAuthResult.class));
    }

    public static void setAuthResult(AppAuthResult result, String userId, String sysId) {
        String cacAuthKey = String.format(TENANT_USER_SYS_AUTH, result.getTenantId(), userId, sysId);
        RedisUtils.set((String)cacAuthKey, (Object)((Object)result), (Duration)RedisCache.calcDuration(result.getExpiredDateTime()));
    }

    public static Duration calcDuration(LocalDateTime expiredDateTime) {
        LocalDateTime now = LocalDateTime.now();
        if (now.plusDays(7L).isBefore(expiredDateTime)) {
            return Duration.ofDays(7L);
        }
        return Duration.between(now, expiredDateTime);
    }

    public static DevInfoVO getDevTenant(String devId) {
        String key = String.format(ISV_DEV_TENANT_ID, devId);
        return (DevInfoVO)RedisUtils.get((Object)key, DevInfoVO.class);
    }

    public static void setDevTenant(String devId, DevInfoVO devInfoVO) {
        String key = String.format(ISV_DEV_TENANT_ID, devId);
        RedisUtils.set((String)key, (Object)devInfoVO, (Duration)Duration.ofDays(1L));
    }

    public static String getDevSecret(String devKey) {
        String key = String.format(ISV_CREDENTIAL, devKey);
        return (String)RedisUtils.get((Object)key, String.class);
    }

    public static void setDevSecret(String devKey, String appSecret) {
        String key = String.format(ISV_CREDENTIAL, devKey);
        RedisUtils.set((String)key, (Object)appSecret, (Duration)Duration.ofDays(1L));
    }

    public static void setIsvCredentialRecord(long tenantSid, String devKey, VerifyLog verifyLog) {
        String key = String.format(ISV_CREDENTIAL_RECORD, tenantSid, devKey);
        RedisUtils.set((String)key, (Object)verifyLog);
    }
}

