package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyCond;
import com.digiwin.dap.middle.ram.entity.Policy;
import com.digiwin.dap.middle.ram.mapper.RamPolicyMapper;
import com.digiwin.dap.middle.ram.service.base.RamPolicyCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamPolicyCrudServiceImpl implements RamPolicyCrudService {

    @Autowired
    private RamPolicyMapper ramPolicyMapper;

    @Override
    public long insert(Policy data) {
        BaseUtils.setCreateFields(data);
        ramPolicyMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramPolicyMapper.deleteBySid(sid);
    }

    @Override
    public long update(Policy data) {
        BaseUtils.setModifyFields(data);
        ramPolicyMapper.update(data);
        return data.getSid();
    }

    @Override
    public Policy findBySid(long sid) {
        return ramPolicyMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Policy data) {
        return ramPolicyMapper.exists(data.getSid());
    }

    @Override
    public List<PolicyVO> findByCond(PolicyCond data) {
        return ramPolicyMapper.findByCond(data);
    }

    @Override
    public PageData<PolicyVO> findByPage(PolicyCond page) {
        long total = ramPolicyMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<PolicyVO> paths = ramPolicyMapper.findByPage(page, Pageable.ofPage(page));
        return PageData.data(total, paths);
    }

    @Override
    public Policy findByAppAndId(String app, String policyId) {
        return ramPolicyMapper.findByAppAndId(app, policyId);
    }
}
