package com.digiwin.dap.middle.ram.service.core;


import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.console.policy.PolicyGrantVO;
import com.digiwin.dap.middle.ram.domain.enums.ApiPolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import com.digiwin.dap.middle.ram.support.web.condition.HttpMethod;

import java.util.List;

/**
 * API中心核心查询
 *
 * @author fobgochod
 * @since 4.36.5
 */
public interface RamBaseGroupService {

    /**
     * 查询特殊策略下绑定的路由
     *
     * @param app        应用
     * @param appId      应用ID
     * @param policyType 策略类型 {@link ApiPolicyType#ApiAccessAllow}  {@link ApiPolicyType#ApiAuthSign}  {@link ApiPolicyType#ApiAuthBase}
     * @return 内部 mapping registry
     */
    MappingRegistry getPattern(String app, String appId, String policyType);

    /**
     * 获取目标的路由<br>
     *
     * @param app        应用
     * @param appId      应用ID
     * @param policyType 策略类型 {@link ApiPolicyType#ApiAccessAllow} {@link ApiPolicyType#ApiAccessDeny}
     * @param targetType 目标类型 {@link TargetType#Sys}
     * @param targetId   目标ID
     * @return 策略设定的路由
     */
    Statement getPolicyRoute(String app, String appId, String policyType, String targetType, String targetId);

    /**
     * 获取订阅该路由的目标
     * <p>
     * 策略类型 {@link ApiPolicyType#ApiSubscribe}
     *
     * @param app        应用
     * @param targetType 目标类型 {@link TargetType#Tenant}
     * @param method     请求方法 {@link HttpMethod}
     * @param path       请求路由
     * @return 授权信息
     */
    List<PolicyGrantVO> findGrantsByRoute(String app, String targetType, String method, String path);

    /**
     * 获取授权该策略的目标ID
     * <p>
     * 策略类型 {@link ApiPolicyType#ApiAccessAllow}
     *
     * @param app        应用
     * @param targetType 目标类型 {@link TargetType}
     * @param policyId   策略ID
     * @param targetId   目录ID
     * @return 授权信息
     */
    boolean existGrant(String app, String targetType, String policyId, String targetId);
}
