package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.BaseSid;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.RouteVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.PolicyRouteCond;
import com.digiwin.dap.middle.ram.entity.PolicyRoute;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 策略关联路由
 *
 * @author fobgochod
 */
@RequestMapping("/api/ram/v2/pr")
@RestController
public class RamPolicyRouteController {

    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody PolicyRoute body) {
        long sid = ramPolicyRouteCrudService.insert(body);
        ramCacheService.policyRouteChange(body.getPolicySid(), body.getRouteSid());
        return StdData.ok(BaseSid.ok(sid));
    }

    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        PolicyRoute policyRoute = ramPolicyRouteCrudService.findBySid(body.getSid());
        if (policyRoute == null) {
            return StdData.ok(BaseSid.ok(0));
        }
        ramPolicyRouteCrudService.deleteBySid(body.getSid());
        ramCacheService.policyRouteChange(policyRoute.getPolicySid(), policyRoute.getRouteSid());
        return StdData.ok(BaseSid.ok(body.getSid()));
    }

    @PostMapping("/search")
    public StdData<?> search(@RequestBody PolicyRouteCond body) {
        return StdData.ok(ramPolicyRouteCrudService.findByPage(body));
    }

    @PostMapping("/find/policy")
    public StdData<?> getPolicy(@RequestBody PolicyRoute body) {
        List<PolicyVO> policies = ramPolicyRouteCrudService.findByRouteSid(body.getRouteSid());
        return StdData.ok(policies);
    }

    @PostMapping("/find/route")
    public StdData<?> getRoute(@RequestBody PolicyRoute body) {
        List<RouteVO> routes = ramPolicyRouteCrudService.findByPolicySid(body.getPolicySid());
        return StdData.ok(routes);
    }
}
