package com.digiwin.dap.middle.ram.domain.request;

import com.digiwin.dap.middle.ram.constant.RamConstant;
import com.fasterxml.jackson.annotation.JsonIgnore;
import org.springframework.util.ObjectUtils;

import jakarta.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AccessInfo implements Serializable {

    private final String id = ObjectUtils.getIdentityHexString(this);

    /**
     * 应用
     * <p>
     * 支持应用独立接入RAM做权限管控，
     * 有点类似于RabbitMQ的Virtual
     */
    private String app = RamConstant.APP;
    /**
     * API真实所属应用ID
     * 比如：/api/iam/v2/identity/login  appId=iam  app=middleware
     */
    @NotBlank
    private String appId;
    @NotBlank
    private String method;
    @NotBlank
    private String path;
    /**
     * 为了应付平台的牛逼功能
     */
    private String tableName;
    @JsonIgnore
    private final Map<String, String> headers = new HashMap<>();

    public String getId() {
        return id;
    }

    public String getApp() {
        return app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Map<String, String> getHeaders() {
        return headers;
    }
}
