package com.digiwin.dap.middle.ram.mapper;

import com.digiwin.dap.middle.ram.domain.console.policy.PolicyGrantVO;
import com.digiwin.dap.middle.ram.domain.vo.GrantVO;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public interface RamExecutorMapper {

    List<PatternVO> findRouteByApp(@Param("app") String app);

    List<PatternVO> findRouteByPolicyId(@Param("app") String app, @Param("policyId") String policyId);

    List<PatternVO> findRouteByPolicyType(@Param("app") String app, @Param("policyType") String policyType);

    List<PolicyVO> findPolicyByPath(@Param("app") String app, @Param("method") String method, @Param("path") String path);

    List<PolicyVO> findPolicyByTargetId(@Param("app") String app, @Param("targetType") String targetType, @Param("targetId") String targetId);

    List<GrantVO> findGrantByPolicyId(@Param("app") String app, @Param("targetType") String targetType, @Param("policyId") String policyId);

    List<PolicyGrantVO> findPolicyGrantByPolicyId(@Param("app") String app, @Param("targetType") String targetType, @Param("policyId") String policyId);

    PolicyGrantVO findGrantByPolicyIdAndTargetId(@Param("app") String app, @Param("targetType") String targetType, @Param("policyId") String policyId, @Param("targetId") String targetId);

    List<PatternVO> findGroupRouteByPolicyType(@Param("app") String app, @Param("policyType") String policyType);

    List<PatternVO> findGroupRouteByPolicyId(@Param("app") String app, @Param("policyId") String policyId);

    List<Long> findGroupSidByPath(@Param("app") String app, @Param("method") String method, @Param("path") String path);
}
