package com.digiwin.dap.middle.ram.service.executor;

import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;

import java.util.List;

public interface RamGrantExecutor {

    /**
     * 获取目标配置的所有策略ID
     * <p>
     * 支持策略类型 {@link PolicyType#AllowList} {@link PolicyType#Base}
     *
     * @param app        应用ID
     * @param targetType 目标类型 {@link TargetType}
     * @param targetId   目标ID
     */
    List<PolicyVO> findPolicyByTargetId(String app, String targetType, String targetId);
}

