/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.domain.request;

import com.digiwin.dap.middle.ram.domain.request.AccessInfo;
import com.digiwin.dap.middleware.auth.AppAuthContext;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;

public class AccessUser
extends AccessInfo {
    private String userToken;
    private long userSid;
    private String userId;
    private String userName;
    private long tenantSid;
    private String tenantId;
    private String tenantName;
    private String appToken;
    private long sysSid;
    private String sysId;
    private boolean inside;
    private boolean platform;
    private AuthResult authResult;

    public static AccessUser of(String appId, String method, String path) {
        AccessUser requestInfo = new AccessUser();
        requestInfo.setAppId(appId);
        requestInfo.setMethod(method);
        requestInfo.setPath(path);
        AppAuthContext context = AppAuthContextHolder.getContext();
        requestInfo.of(context.getAuthoredUser(), context.getAuthoredSys());
        return requestInfo;
    }

    public void of(AuthoredUser authoredUser, AuthoredSys authoredSys) {
        if (authoredUser != null) {
            this.setTenantSid(authoredUser.getTenantSid());
            this.setTenantId(authoredUser.getTenantId());
            this.setTenantName(authoredUser.getTenantName());
            this.setUserToken(authoredUser.getToken());
            this.setUserSid(authoredUser.getSid());
            this.setUserId(authoredUser.getUserId());
            this.setUserName(authoredUser.getUserName());
        }
        if (authoredSys != null) {
            this.setAppToken(authoredSys.getToken());
            this.setSysSid(authoredSys.getSid());
            this.setSysId(authoredSys.getId());
            this.setInside(authoredSys.isInside());
            this.setPlatform(authoredSys.isPlatform());
        }
    }

    public String getUserToken() {
        return this.userToken;
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public long getUserSid() {
        return this.userSid;
    }

    public void setUserSid(long userSid) {
        this.userSid = userSid;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public long getTenantSid() {
        return this.tenantSid;
    }

    public void setTenantSid(long tenantSid) {
        this.tenantSid = tenantSid;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTenantName() {
        return this.tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public String getAppToken() {
        return this.appToken;
    }

    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    public long getSysSid() {
        return this.sysSid;
    }

    public void setSysSid(long sysSid) {
        this.sysSid = sysSid;
    }

    public String getSysId() {
        return this.sysId;
    }

    public void setSysId(String sysId) {
        this.sysId = sysId;
    }

    public boolean isInside() {
        return this.inside;
    }

    public void setInside(boolean inside) {
        this.inside = inside;
    }

    public boolean isPlatform() {
        return this.platform;
    }

    public void setPlatform(boolean platform) {
        this.platform = platform;
    }

    public AuthResult getAuthResult() {
        return this.authResult;
    }

    public void setAuthResult(AuthResult authResult) {
        this.authResult = authResult;
    }

    public String securityLog() {
        return "{\"type\":\"[cyberSecurity]\",\"method\":\"" + this.getMethod() + "\",\"path\":\"" + this.getPath() + "\",\"userId\":\"" + this.getUserId() + "\",\"userName\":\"" + this.getUserName() + "\",\"tenantId\":\"" + this.getTenantId() + "\",\"tenantName\":\"" + this.getTenantName() + "\",\"userToken\":\"" + this.getUserToken() + "\",\"appToken\":\"" + this.getAppToken() + "\",\"logEnd\":\"[cyberSecurityLogEnd]\"}";
    }
}

