/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.access.api.handler;

import com.digiwin.dap.middle.ram.domain.PolicyOrder;
import com.digiwin.dap.middle.ram.domain.access.ApiAccessUser;
import com.digiwin.dap.middle.ram.domain.console.policy.PolicyGrantVO;
import com.digiwin.dap.middle.ram.domain.enums.ApiPolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.access.api.RamApiPolicyHandler;
import com.digiwin.dap.middle.ram.service.core.RamBaseGroupService;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import java.util.List;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

@Service
public class RamAuthBaseApiPolicyHandler
extends RamApiPolicyHandler
implements Ordered {
    public RamAuthBaseApiPolicyHandler(RamBaseGroupService ramBaseGroupService) {
        super(ramBaseGroupService);
    }

    @Override
    public AccessResult handle(ApiAccessUser request) {
        MappingRegistry mappingRegistry = this.ramBaseGroupService.getPattern(request.getApp(), request.getAppId(), ApiPolicyType.ApiAuthBase.name());
        PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry);
        if (matched == null) {
            return AccessResult.next();
        }
        try {
            List<PolicyGrantVO> grants = this.ramBaseGroupService.findGrantsByRoute(request.getApp(), TargetType.Tenant.name(), matched.getMethod(), matched.getPath());
            PolicyGrantVO.checkValidGrant(grants, request);
            return AccessResult.allow();
        }
        catch (Exception e) {
            throw new UnauthorizedException((ErrorHandler)ResultType.EXPLICIT_DENY, e.getMessage());
        }
    }

    public int getOrder() {
        return PolicyOrder.API_AUTH_BASE.order();
    }
}

