/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.service.access.apisub.handler;

import com.digiwin.dap.middle.ram.domain.PolicyOrder;
import com.digiwin.dap.middle.ram.domain.access.ApiSubAccessUser;
import com.digiwin.dap.middle.ram.domain.access.AuthMode;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.sign.ApiSignInfo;
import com.digiwin.dap.middle.ram.service.access.apisub.RamApiSubPolicyHandler;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapSign;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.VerifyUtils;
import java.util.Map;
import org.springframework.core.Ordered;

public class RamSignApiSubPolicyHandler
extends RamApiSubPolicyHandler
implements Ordered {
    private final RamHandlerSupport ramHandlerSupport;

    public RamSignApiSubPolicyHandler(RamHandlerSupport ramHandlerSupport) {
        this.ramHandlerSupport = ramHandlerSupport;
    }

    @Override
    public AccessResult handle(ApiSubAccessUser request) {
        if (request.getAuthMode() == AuthMode.SIGN_COUNT) {
            try {
                this.verifySign(request);
            }
            catch (Exception e) {
                throw new UnauthorizedException((ErrorHandler)ResultType.EXPLICIT_DENY, e.getMessage());
            }
        }
        return AccessResult.next();
    }

    private void verifySign(ApiSubAccessUser request) {
        ApiSignInfo signInfo;
        String signHeader = request.getHeaders().get(DapHttpHeaders.DEV_ARGS.getHeader());
        try {
            signInfo = (ApiSignInfo)((Object)ApiSignInfo.get((String)signHeader, ApiSignInfo.class));
        }
        catch (Exception e) {
            throw new UnauthorizedException((ErrorHandler)CommonErrorCode.SIGN_HEADER_ARG_PARSING_FAILED, new Object[]{signHeader});
        }
        VerifyUtils.sign((DapSign)signInfo, () -> true);
        String devKey = request.getHeaders().get(DapHttpHeaders.DEV_ID.getHeader());
        String devSecret = this.ramHandlerSupport.getDevSecret(request.getUserToken(), devKey);
        signInfo.setMethod(request.getMethod());
        signInfo.setPath(request.getPath());
        signInfo.setDevKey(devKey);
        signInfo.setUserToken(request.getUserToken());
        boolean verified = SignUtils.verify((Map)JsonUtils.objToMap((Object)((Object)signInfo)), (String)devSecret, (Map[])new Map[0]);
        if (!verified) {
            throw new UnauthorizedException((ErrorHandler)CommonErrorCode.SIGN_INCONSISTENT_SIGNATURE);
        }
    }

    public int getOrder() {
        return PolicyOrder.API_SUB_SIGN.order();
    }
}

