/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.cache;

import com.digiwin.dap.middle.ram.support.cache.LocalCacheHolder;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public class CachePurgeMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(CachePurgeMessageListener.class);

    public void onMessage(Message message, byte[] pattern) {
        String body = new String(message.getBody(), StandardCharsets.UTF_8);
        logger.info("local cache purge: {}", (Object)body);
        String[] parts = body.split("@");
        if (parts.length != 2) {
            return;
        }
        String cacheType = parts[0];
        String cacheKey = parts[1];
        LocalCacheHolder.remove(cacheType, cacheKey);
    }
}

