package com.digiwin.dap.middle.ram.api;

import com.digiwin.dap.middle.ram.domain.vo.PolicyVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.RouteCond;
import com.digiwin.dap.middle.ram.domain.BaseSid;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.service.base.RamPolicyRouteCrudService;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middle.ram.service.core.RamCacheService;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 路由信息
 *
 * @author fobgochod
 */
@RequestMapping("/api/ram/v2/route")
@RestController
public class RamRouteController {

    @Autowired
    private RamCacheService ramCacheService;
    @Autowired
    private RamRouteCrudService ramRouteCrudService;
    @Autowired
    private RamPolicyRouteCrudService ramPolicyRouteCrudService;

    @PostMapping("/add")
    public StdData<?> add(@RequestBody Route body) {
        long routeSid = ramRouteCrudService.insert(body);
        ramCacheService.routeChange(body.getApp());
        return StdData.ok(BaseSid.ok(routeSid));
    }

    @PostMapping("/del")
    public StdData<?> del(@RequestBody BaseSid body) {
        Route route = ramRouteCrudService.findBySid(body.getSid());
        if (route == null) {
            return StdData.ok(BaseSid.ok(0));
        }
        List<PolicyVO> routePolicies = ramPolicyRouteCrudService.findByRouteSid(body.getSid());
        if (!routePolicies.isEmpty()) {
            String grant = routePolicies.stream().map(PolicyVO::getId).collect(Collectors.joining(","));
            throw new BusinessException(String.format("该路由被策略[%s]使用，不允许删除", grant));
        }
        ramRouteCrudService.deleteBySid(body.getSid());
        ramCacheService.routeChange(route.getApp());
        return StdData.ok(BaseSid.ok(body.getSid()));
    }

    @PostMapping("/mod")
    public StdData<?> mod(@RequestBody Route body) {
        Route route = ramRouteCrudService.findBySid(body.getSid());
        if (route != null) {
            route.setName(body.getName());
            route.setRemark(body.getRemark());
            ramRouteCrudService.update(route);
        }
        return StdData.ok(route);
    }

    @PostMapping("/get")
    public StdData<?> get(@RequestBody BaseSid body) {
        Route route = ramRouteCrudService.findBySid(body.getSid());
        return StdData.ok(route);
    }

    @PostMapping("/find")
    public StdData<?> find(@RequestBody RouteCond body) {
        return StdData.ok(ramRouteCrudService.findByCond(body));
    }

    @PostMapping("/search")
    public StdData<?> search(@RequestBody RouteCond body) {
        return StdData.ok(ramRouteCrudService.findByPage(body));
    }
}
