package com.digiwin.dap.middle.ram.constant;

import com.digiwin.dap.middle.ram.support.RamMessageSource;
import com.digiwin.dap.middleware.domain.ErrorHandler;

/**
 * 统一错误码
 *
 * @author fobgochod
 */
public enum RamI18nError implements ErrorHandler {


    CYBER_SECURITY("1S201", "dap.middleware.ram.access.implicit"),
    CAC_AUTH_GET_FAIL("21009", "cac.auth.get.fail"),
    API_POLICY_ACCESS_DENY("20000", "dap.middleware.ram.api.policy.access.deny"),
    API_SUBSCRIBE_NONE("20000", "dap.middleware.ram.api.grant.none"),
    API_SUBSCRIBE_EXPIRED("20000", "dap.middleware.ram.api.grant.expired"),
    API_DEV_SECRET_NONE("20000", "dap.middleware.ram.api.dev.secret.none"),
    API_DEV_TENANT_NONE("20000", "dap.middleware.ram.api.dev.tenant.none"),
    CAC_AUTH_COUNT_ZERO("20000", "cac.auth.count.zero"),
    IAM_AUTH_CODE_INVALID("20000", "iam.auth.code.invalid"),
    PARAM_EMPTY("20000", "dap.middleware.ram.param.empty"),
    PROJECT_EXISTED("20000", "dap.middleware.ram.project.existed"),
    PROJECT_NOT_EXIST("20000", "dap.middleware.ram.project.not.exist"),
    GROUP_EXISTED("20000", "dap.middleware.ram.group.existed"),
    GROUP_NOT_EXIST("20000", "dap.middleware.ram.group.not.exist"),
    ROUTE_NOT_EXIST("20000", "dap.middleware.ram.route.not.exist"),
    ;

    private final String errorCode;
    private final String code;

    RamI18nError(String errorCode, String code) {
        this.errorCode = errorCode;
        this.code = code;
    }

    public static boolean containsCode(String code) {
        for (RamI18nError value : RamI18nError.values()) {
            if (value.getCode().equals(code)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getErrorCode() {
        return errorCode;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getErrorMessage() {
        return RamMessageSource.getAccessor().getMessage(code);
    }
}
