package com.digiwin.dap.middle.ram.domain.page;

/**
 * 分页信息
 *
 * @author fobgochod
 */
public class Page {

    /**
     * 页码，从1开始
     */
    private int pageNum;
    /**
     * 页面大小，默认10
     */
    private int pageSize;
    /**
     * 排序
     */
    private String orderBy;
    /**
     * 总数
     */
    private long total;

    public Page() {
        this.pageNum = 1;
        this.pageSize = 10;
    }


    public int getPageNum() {
        return pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public long getTotal() {
        return total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int skip() {
        return (this.pageNum - 1) * this.pageSize;
    }

    public int limit() {
        return this.pageSize;
    }
}
