package com.digiwin.dap.middle.ram.service.access.apisub;

import com.digiwin.dap.middle.ram.domain.PolicyOrder;
import com.digiwin.dap.middle.ram.domain.access.ApiSubAccessUser;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.service.access.apisub.handler.RamAuthApiSubPolicyHandler;
import com.digiwin.dap.middle.ram.service.access.apisub.handler.RamSignApiSubPolicyHandler;
import com.digiwin.dap.middle.ram.support.RamHandlerSupport;
import com.digiwin.dap.middle.ram.support.security.PolicyChain;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@ConditionalOnProperty(prefix = "dap.middleware", value = "api-sub", havingValue = "true")
public class RamApiSubPolicyHandlerComposite extends RamApiSubPolicyHandler implements Ordered {

    private final List<RamApiSubPolicyHandler> handlers = new ArrayList<>(2);

    public RamApiSubPolicyHandlerComposite(RamHandlerSupport ramHandlerSupport) {
        this.handlers.add(new RamSignApiSubPolicyHandler(ramHandlerSupport));
        this.handlers.add(new RamAuthApiSubPolicyHandler(ramHandlerSupport));
    }

    @Override
    public AccessResult handle(ApiSubAccessUser request) {
        PolicyChain<ApiSubAccessUser> chain = new PolicyChain<>(handlers);
        return chain.doNextStep(request);
    }

    @Override
    public int getOrder() {
        return PolicyOrder.API_SUB.order();
    }
}
