package com.digiwin.dap.middle.ram.service.base.impl;

import com.digiwin.dap.middle.ram.domain.page.PageData;
import com.digiwin.dap.middle.ram.domain.page.Pageable;
import com.digiwin.dap.middle.ram.domain.vo.RouteVO;
import com.digiwin.dap.middle.ram.domain.vo.condition.RouteCond;
import com.digiwin.dap.middle.ram.entity.Route;
import com.digiwin.dap.middle.ram.mapper.RamRouteMapper;
import com.digiwin.dap.middle.ram.service.base.RamRouteCrudService;
import com.digiwin.dap.middle.ram.util.BaseUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RamRouteCrudServiceImpl implements RamRouteCrudService {

    @Autowired
    private RamRouteMapper ramRouteMapper;

    @Override
    public long insert(Route data) {
        BaseUtils.setCreateFields(data);
        ramRouteMapper.insert(data);
        return data.getSid();
    }

    @Override
    public int deleteBySid(long sid) {
        return ramRouteMapper.deleteBySid(sid);
    }

    @Override
    public long update(Route data) {
        BaseUtils.setModifyFields(data);
        ramRouteMapper.update(data);
        return data.getSid();
    }

    @Override
    public Route findBySid(long sid) {
        return ramRouteMapper.findBySid(sid);
    }

    @Override
    public boolean exists(Route data) {
        return ramRouteMapper.existsBySid(data.getSid());
    }

    @Override
    public Route findByAppAndMethodAndPath(String app, String method, String path) {
        return ramRouteMapper.findByAppAndMethodAndPath(app, method, path);
    }

    @Override
    public List<RouteVO> findByCond(RouteCond cond) {
        return ramRouteMapper.findByCond(cond);
    }

    @Override
    public PageData<RouteVO> findByPage(RouteCond page) {
        long total = ramRouteMapper.countByPage(page);
        if (total == 0) {
            return PageData.empty();
        }
        List<RouteVO> paths = ramRouteMapper.findByPage(page, Pageable.ofPage(page));
        return PageData.data(total, paths);
    }
}
