package com.digiwin.dap.middle.ram.support.security.path.handler;

import com.digiwin.dap.middle.ram.domain.Statement;
import com.digiwin.dap.middle.ram.domain.TargetInfo;
import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessInfo;
import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.domain.vo.PatternVO;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.TargetChain;
import com.digiwin.dap.middle.ram.support.security.TargetHandler;
import com.digiwin.dap.middle.ram.support.security.path.PathPolicyHandler;
import com.digiwin.dap.middle.ram.support.web.MappingRegistry;
import com.digiwin.dap.middle.ram.util.MatcherUtils;
import org.springframework.core.annotation.Order;

/**
 * 白名单，策略类型 {@link PolicyType#AllowList}
 * <p>
 * 该策略下的API，目标设定拥有该策略才可以访问，其他目标一律不能访问
 *
 * @author fobgochod
 */
@Order(200)
public class AllowListPathPolicyHandler extends PathPolicyHandler<AccessUser> implements TargetHandler<AccessInfo> {

    public AllowListPathPolicyHandler(RamCoreService ramCoreService) {
        super(ramCoreService);
    }

    @Override
    public AccessResult handle(AccessUser request) {
        // 1.查询所有白名单API
        MappingRegistry mappingRegistry = ramCoreService.getPattern(request.getApp(), PolicyType.AllowList.name());
        if (!mappingRegistry.isEmpty()) {
            // 2.当前访问API和白名单集合进行匹配
            PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), mappingRegistry);
            if (matched != null) {
                // 2.1.当前API在白名单集合中，依次进行匹配
                TargetChain<AccessInfo> chain = new TargetChain<>(this, TargetInfo.getTargets(request));
                AccessResult accessResult = chain.doNextStep(request);
                // 3.有则允许，没有则拒绝
                return accessResult.getResultType() == ResultType.ALLOW ? accessResult : AccessResult.deny(matched.getPolicyId());
            }
        }
        // 2.2.当前API不在白名单集合中
        return AccessResult.next();
    }

    @Override
    public AccessResult handle(TargetType targetType, String targetId, AccessInfo request) {
        Statement statement = ramCoreService.getPolicyRoute(request.getApp(), PolicyType.AllowList.name(), targetType.name(), targetId);
        if (!statement.getAllow().isEmpty()) {
            PatternVO matched = MatcherUtils.matches(request.getMethod(), request.getPath(), statement.getAllow());
            if (matched != null) {
                return AccessResult.allow();
            }
        }
        return AccessResult.next();
    }
}
