/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.domain.request;

import com.digiwin.dap.middle.ram.domain.enums.ResultType;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.UnauthorizedException;

public class AccessResult {
    private String policyId;
    private ResultType resultType;

    public AccessResult() {
    }

    public AccessResult(ResultType resultType) {
        this.resultType = resultType;
    }

    public static AccessResult allow() {
        return new AccessResult(ResultType.ALLOW);
    }

    public static AccessResult deny(String policyId) {
        AccessResult accessResult = new AccessResult(ResultType.EXPLICIT_DENY);
        accessResult.setPolicyId(policyId);
        return accessResult;
    }

    public static AccessResult next() {
        return new AccessResult(ResultType.IMPLICIT_DENY);
    }

    public void checkAccessResult() {
        if (this.resultType == ResultType.EXPLICIT_DENY) {
            throw new UnauthorizedException((ErrorHandler)ResultType.EXPLICIT_DENY, String.format("\u5b9e\u9645\u751f\u6548\u7b56\u7565(%s)", this.policyId));
        }
    }

    public String getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(String policyId) {
        this.policyId = policyId;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(ResultType resultType) {
        this.resultType = resultType;
    }
}

