/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.web.condition;

import com.digiwin.dap.middle.ram.support.web.condition.AbstractCondition;
import com.digiwin.dap.middle.ram.support.web.condition.HttpMethod;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;

public final class MethodsCondition
extends AbstractCondition {
    private static final MethodsCondition GET_CONDITION = new MethodsCondition(HttpMethod.GET);
    private final Set<HttpMethod> methods;

    public MethodsCondition(HttpMethod ... requestMethods) {
        this(Arrays.asList(requestMethods));
    }

    private MethodsCondition(Collection<HttpMethod> requestMethods) {
        this.methods = Collections.unmodifiableSet(new LinkedHashSet<HttpMethod>(requestMethods));
    }

    public Set<HttpMethod> getMethods() {
        return this.methods;
    }

    protected Collection<HttpMethod> getContent() {
        return this.methods;
    }

    @Nullable
    public MethodsCondition getMatchingCondition(String httpMethodValue) {
        HttpMethod method = HttpMethod.resolve(httpMethodValue);
        if (this.getMethods().isEmpty()) {
            if (HttpMethod.OPTIONS == method) {
                return null;
            }
            return this;
        }
        return this.matchRequestMethod(method);
    }

    @Nullable
    public MethodsCondition getMatchingCondition(HttpServletRequest request) {
        HttpMethod method = HttpMethod.resolve(request.getMethod());
        if (this.getMethods().isEmpty()) {
            if (HttpMethod.OPTIONS == method && !DispatcherType.ERROR.equals((Object)request.getDispatcherType())) {
                return null;
            }
            return this;
        }
        return this.matchRequestMethod(method);
    }

    @Nullable
    private MethodsCondition matchRequestMethod(HttpMethod httpMethod) {
        if (httpMethod != null) {
            for (HttpMethod method : this.getMethods()) {
                if (httpMethod != method) continue;
                return new MethodsCondition(method);
            }
            if (httpMethod == HttpMethod.HEAD && this.getMethods().contains((Object)HttpMethod.GET)) {
                return GET_CONDITION;
            }
        }
        return null;
    }
}

