package com.digiwin.dap.middle.ram.domain.remote;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 租户应用授权结果
 *
 * @author fobgochod
 */
public class AuthResultVO {

    /**
     * 租户id
     */
    private String tenantId;
    /**
     * 商品code
     */
    private String goodsCode;
    /**
     * 授权类型 0-次 3-不控制
     */
    private Integer paymentType;
    /**
     * 可使用次数
     */
    private Integer totalUsage;
    /**
     * 剩余次数
     */
    private Integer remainUsage;
    /**
     * 授权模组信息，API商品是应用信息
     */
    private List<AuthModuleVO> modules;
    /**
     * api授权商品-技能中心
     */
    private List<ApiGoodsVO> apiGoods;

    /**
     * api 授权信息
     */
    private List<AuthApiVO> apis;

    /**
     * 商品类型
     */
    private String category;

    /**
     * 授权生效时间
     */
    private LocalDateTime effectiveDateTime;

    /**
     * 授权失效时间
     */
    private LocalDateTime expiredDateTime;

    /**
     * 计量商品信息
     */
    private AuthResultVO resourceGood;


    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getGoodsCode() {
        return goodsCode;
    }

    public void setGoodsCode(String goodsCode) {
        this.goodsCode = goodsCode;
    }

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    public Integer getTotalUsage() {
        return totalUsage;
    }

    public void setTotalUsage(Integer totalUsage) {
        this.totalUsage = totalUsage;
    }

    public Integer getRemainUsage() {
        return remainUsage;
    }

    public void setRemainUsage(Integer remainUsage) {
        this.remainUsage = remainUsage;
    }

    public List<AuthModuleVO> getModules() {
        return modules;
    }

    public void setModules(List<AuthModuleVO> modules) {
        this.modules = modules;
    }

    public List<ApiGoodsVO> getApiGoods() {
        return apiGoods;
    }

    public void setApiGoods(List<ApiGoodsVO> apiGoods) {
        this.apiGoods = apiGoods;
    }

    public List<AuthApiVO> getApis() {
        return apis;
    }

    public void setApis(List<AuthApiVO> apis) {
        this.apis = apis;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public AuthResultVO getResourceGood() {
        return resourceGood;
    }

    public void setResourceGood(AuthResultVO resourceGood) {
        this.resourceGood = resourceGood;
    }

    public LocalDateTime getEffectiveDateTime() {
        return effectiveDateTime;
    }

    public void setEffectiveDateTime(LocalDateTime effectiveDateTime) {
        this.effectiveDateTime = effectiveDateTime;
    }

    public LocalDateTime getExpiredDateTime() {
        return expiredDateTime;
    }

    public void setExpiredDateTime(LocalDateTime expiredDateTime) {
        this.expiredDateTime = expiredDateTime;
    }
}