package com.digiwin.dap.middle.ram.service.executor.redis;

import com.digiwin.dap.middle.ram.domain.console.policy.PolicyGrantVO;
import com.digiwin.dap.middle.ram.service.executor.RamGroupGrantExecutor;
import com.digiwin.dap.middleware.constant.CacheConstants;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.Cacheable;

import java.util.List;

@CacheConfig(cacheNames = CacheConstants.TTL_12H, cacheManager = CacheConstants.DAP_CACHE_MANAGER)
public class RamGroupGrantCachingExecutor implements RamGroupGrantExecutor {

    private final RamGroupGrantExecutor delegate;

    public RamGroupGrantCachingExecutor(RamGroupGrantExecutor delegate) {
        this.delegate = delegate;
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getPolicyGrantByPolicyId(#app, #targetType, #policyId)")
    @Override
    public List<PolicyGrantVO> findPolicyGrantByPolicyId(String app, String targetType, String policyId) {
        return delegate.findPolicyGrantByPolicyId(app, targetType, policyId);
    }

    @Cacheable(key = "T(com.digiwin.dap.middle.ram.support.cache.CacheKeyBuilder).getGrantByPolicyIdAndTargetId(#app, #targetType, #policyId, #targetId)")
    @Override
    public PolicyGrantVO findGrantByPolicyIdAndTargetId(String app, String targetType, String policyId, String targetId) {
        return delegate.findGrantByPolicyIdAndTargetId(app, targetType, policyId, targetId);
    }
}
