package com.digiwin.dap.middle.ram.support.cache;

public class CacheKeyBuilder {

    private static final String RAM = "ram";
    private static final String COLON = ":";
    private static final String GRANT = "grant";
    private static final String POLICY = "policy";
    private static final String ROUTE = "route";
    private static final String TARGET = "target";
    private static final String GROUP = "group";

    /**
     * 应用:目标类型:目标ID
     * <p>
     * ram:grant:policy:app:targetType:targetId
     */
    public static String getPolicyByTargetId(String prefix, String app, String targetType, String targetId) {
        return String.join(":", prefix, getPolicyByTargetId(app, targetType, targetId));
    }

    // ram:grant:policy:app:targetType:targetId
    public static String getPolicyByTargetId(String app, String targetType, String targetId) {
        return String.join(COLON, RAM, GRANT, POLICY, app, targetType, targetId);
    }


    /**
     * 应用:策略ID
     * <p>
     * ram:policy:app:policyId
     */
    public static String getRouteByPolicyId(String prefix, String app, String policyId) {
        return String.join(":", prefix, getRouteByPolicyId(app, policyId));
    }

    // ram:policy:app:policyId
    public static String getRouteByPolicyId(String app, String policyId) {
        return String.join(COLON, RAM, POLICY, app, policyId);
    }


    /**
     * 应用:策略类型
     * <p>
     * ram:policy:app:policyType
     */
    public static String getRouteByPolicyType(String prefix, String app, String policyType) {
        return String.join(":", prefix, getRouteByPolicyType(app, policyType));
    }

    // ram:policy:app:policyType
    public static String getRouteByPolicyType(String app, String policyType) {
        return String.join(COLON, RAM, POLICY, app, policyType);
    }


    /**
     * 应用:{方法 路由}
     * <p>
     * ram:policy:app:{method path}
     */
    public static String getPolicyByPath(String prefix, String app, String method, String path) {
        return String.join(":", prefix, getPolicyByPath(app, method, path));
    }

    // ram:policy:app:{method path}
    public static String getPolicyByPath(String app, String method, String path) {
        return String.join(COLON, RAM, POLICY, app, "{" + method + " " + path + "}");
    }


    /**
     * 应用ID
     * ram:route:appId
     */
    public static String getRouteByApp(String prefix, String appId) {
        return String.join(":", prefix, getRouteByApp(appId));
    }

    // ram:route:appId
    public static String getRouteByApp(String appId) {
        return String.join(COLON, RAM, ROUTE, appId);
    }

    // grant:target:app:targetType:policyId
    public static String getPolicyGrantByPolicyId(String app, String targetType, String policyId) {
        return String.join(COLON, GRANT, TARGET, app, targetType, policyId);
    }

    // grant:target:app:targetType:policyId:targetId
    public static String getGrantByPolicyIdAndTargetId(String app, String targetType, String policyId, String targetId) {
        return String.join(COLON, GRANT, TARGET, app, targetType, policyId, targetId);
    }

    // policy:app:policyType
    public static String getGroupRouteByPolicyType(String app, String policyType) {
        return String.join(COLON, POLICY, app, policyType);
    }

    // policy:app:policyId
    public static String getGroupRouteByPolicyId(String app, String policyId) {
        return String.join(COLON, POLICY, app, policyId);
    }

    // group:app:{method path}
    public static String getGroupSidByRoute(String app, String method, String path) {
        return String.join(COLON, GROUP, app, "{" + method + " " + path + "}");
    }
}
