package com.digiwin.dap.middle.ram.support.iam;

import com.digiwin.dap.middle.ram.support.RamCacheSupport;
import com.digiwin.dap.middleware.constant.BeanConstants;
import com.digiwin.dap.middleware.constant.InternalUrl;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.StdData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.web.client.RestTemplate;

import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultRamCacheSupport implements RamCacheSupport {

    private static final Logger logger = LoggerFactory.getLogger(DefaultRamCacheSupport.class);
    @Autowired
    private DapEnv dapEnv;
    @Resource(name = BeanConstants.DAP_RETRY_TEMPLATE)
    private RestTemplate retryRestTemplate;

    public List<String> getSysByPlatformId(String platformId) {
        return getAppIds(platformId, true);
    }

    public List<String> getPlatformSysBySysId(String sysId) {
        return getAppIds(sysId, false);
    }

    private List<String> getAppIds(String sysId, boolean platform) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            Map<String, Object> requestBody = new HashMap<>();
            requestBody.put("id", sysId);
            requestBody.put("platform", platform);
            HttpEntity<Map<String, Object>> httpEntity = new HttpEntity<>(requestBody, headers);

            String uri = dapEnv.getIamUri() + InternalUrl.SYS_PLATFORM_IDS;
            ResponseEntity<StdData<List<String>>> result = retryRestTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<StdData<List<String>>>() {
            });
            return result.getBody().getData();
        } catch (Exception e) {
            logger.error("获取应或用平台", e);
        }
        return Collections.emptyList();
    }
}