package com.digiwin.dap.middle.ram.support.security.path.handler;

import com.digiwin.dap.middle.ram.domain.request.AccessResult;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.support.security.path.PathPolicyHandler;
import com.digiwin.dap.middleware.constant.InternalUrl;
import org.springframework.core.annotation.Order;

/**
 * 全局不参与，特殊策略类型
 * <p>
 * 针对一些特殊的访问量高且不需要管控的API，如登录、Token解析等
 * <ol>
 *     <li>减少不必要的白名单配置</li>
 *     <li>优化效率，减少缓存查询和比较</li>
 * </ol>
 *
 * @author fobgochod
 */
@Order(100)
public class BeforePathPolicyHandler extends PathPolicyHandler<AccessUser> {

    @Override
    public AccessResult handle(AccessUser request) {
        if (InternalUrl.policy().contains(request.getPath())) {
            return AccessResult.allow();
        }
        return AccessResult.next();
    }
}
