/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.domain.console.policy;

import com.digiwin.dap.middle.ram.constant.RamI18nError;
import com.digiwin.dap.middle.ram.domain.access.ApiAccessUser;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PolicyGrantVO {
    private String type;
    private String id;
    private LocalDateTime attachDate;
    private LocalDateTime expiredDate;

    public static void checkValidGrant(List<PolicyGrantVO> grants, ApiAccessUser request) {
        Optional<PolicyGrantVO> optional = grants.stream().filter(p -> Objects.equals(p.getId(), request.getDevTenantId())).findFirst();
        if (optional.isPresent()) {
            if (LocalDateTime.now().isAfter(optional.get().getExpiredDate())) {
                throw new BusinessException((ErrorHandler)RamI18nError.API_SUBSCRIBE_EXPIRED, new Object[]{request.getDevTenantId()});
            }
        } else {
            throw new BusinessException((ErrorHandler)RamI18nError.API_SUBSCRIBE_NONE, new Object[]{request.getDevTenantId(), request.getMethod(), request.getPath()});
        }
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LocalDateTime getAttachDate() {
        return this.attachDate;
    }

    public void setAttachDate(LocalDateTime attachDate) {
        this.attachDate = attachDate;
    }

    public LocalDateTime getExpiredDate() {
        return this.expiredDate;
    }

    public void setExpiredDate(LocalDateTime expiredDate) {
        this.expiredDate = expiredDate;
    }

    public String toString() {
        return this.id + "[" + String.valueOf(this.expiredDate) + "]";
    }
}

