/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.ram.support.security.auth.handler;

import com.digiwin.dap.middle.ram.domain.enums.PolicyType;
import com.digiwin.dap.middle.ram.domain.enums.TargetType;
import com.digiwin.dap.middle.ram.domain.request.AccessUser;
import com.digiwin.dap.middle.ram.service.core.RamCoreService;
import com.digiwin.dap.middle.ram.support.security.auth.AuthPolicyHandler;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import java.util.List;
import org.springframework.core.annotation.Order;

@Order(value=20)
public class NoAuthUserAuthPolicyHandler
extends AuthPolicyHandler {
    public NoAuthUserAuthPolicyHandler(RamCoreService ramCoreService) {
        this.ramCoreService = ramCoreService;
    }

    @Override
    public boolean supports(AuthType authType) {
        return authType == AuthType.AppNoneUser;
    }

    @Override
    public AuthResult process(AuthResult authResult, AccessUser request) {
        List<String> policyId = this.ramCoreService.findPolicyId(request.getApp(), PolicyType.NoAuthUser.name(), TargetType.Sys.name(), request.getSysId());
        if (!policyId.isEmpty()) {
            authResult.setAuthType(AuthType.AppOk);
        } else {
            policyId = this.ramCoreService.findPolicyId(request.getApp(), PolicyType.NoAuthUser.name(), TargetType.TenantSys.name(), request.getTenantId() + "-" + request.getSysId());
            if (!policyId.isEmpty()) {
                authResult.setAuthType(AuthType.AppOk);
            }
        }
        return authResult;
    }
}

