/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.sql.safe.api;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middle.sql.safe.domain.SqlRequest;
import com.digiwin.dap.middle.sql.safe.domain.SqlRule;
import com.digiwin.dap.middle.sql.safe.service.CountSqlBuilder;
import com.digiwin.dap.middle.sql.safe.service.SqlSafeValidator;
import com.digiwin.dap.middle.sql.safe.service.SqlWhitelistLoader;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.SignUtils;
import com.digiwin.dap.middleware.commons.util.EncryptUtils;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import com.digiwin.dap.middleware.constant.GlobalConstants;
import com.digiwin.dap.middleware.domain.CommonCode;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.domain.DapSign;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.PageData;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.ThirdCallException;
import com.digiwin.dap.middleware.support.EnvSupport;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.digiwin.dap.middleware.util.VerifyUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/api/${spring.application.name}/v2/admin/sql"})
public class AdminSQLController {
    @Autowired
    private DapEnv dapEnv;
    @Autowired
    private EnvSupport envSupport;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private RestTemplate restTemplate;

    @PostMapping(value={"/query"})
    public StdData<?> query(@RequestBody SqlRequest body) {
        Object[] args;
        String querySql = AES.decrypt((String)body.getSql(), (String)KeyConstant.WECHAT_UNION_ID);
        if (StrUtils.isEmpty((String)querySql)) {
            return StdData.ok(Collections.emptyMap());
        }
        if (CommonCode.BOSS.name().equals(this.dapEnv.getAppName().toUpperCase())) {
            SqlRule sqlRule = SqlWhitelistLoader.load(this.jdbcTemplate);
            SqlSafeValidator sqlSafeValidator = SqlSafeValidator.build(body.getApp(), sqlRule);
            sqlSafeValidator.validate(querySql);
            if (!CommonCode.IAM.name().equalsIgnoreCase(body.getApp()) && !CommonCode.BOSS.name().equalsIgnoreCase(body.getApp())) {
                String signParam = EncryptUtils.sign((String)KeyConstant.OTHER, Collections.singletonMap("sql", querySql));
                body.setSign(signParam);
                return this.querySql(body);
            }
        } else {
            SqlRequest dapSign = (SqlRequest)((Object)SqlRequest.get((String)body.getSign(), SqlRequest.class));
            dapSign.setSql(querySql);
            VerifyUtils.sign((DapSign)dapSign, () -> true);
            SignUtils.verify((Map)JsonUtils.objToMap((Object)((Object)dapSign)), (String)KeyConstant.OTHER, (Map[])new Map[0]);
        }
        String countSql = CountSqlBuilder.buildCountSql(querySql);
        Object[] objectArray = args = body.getParams() == null ? new Object[]{} : body.getParams().toArray();
        if (countSql != null) {
            Long count = (Long)this.jdbcTemplate.queryForObject(countSql, Long.class, args);
            if (StrUtils.isEmpty((Long)count)) {
                return StdData.ok((Object)PageData.zero());
            }
            List list = this.jdbcTemplate.queryForList(querySql, args);
            return StdData.ok((Object)PageData.data((long)count, (List)list));
        }
        List list = this.jdbcTemplate.queryForList(querySql, args);
        return StdData.ok((Object)list);
    }

    private StdData<?> querySql(SqlRequest body) {
        CommonCode app = CommonCode.ofName((String)body.getApp());
        String domain = DeployAreaEnum.isDev((String)this.dapEnv.getDeployArea()) ? this.envSupport.getUri(app) : this.envSupport.getLocalUri(app);
        String path = "/api/" + app.getPath() + "/v2/admin/sql/query";
        String uri = domain + path;
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstants.HTTP_HEADER_USER_TOKEN_KEY, UserUtils.getToken());
            HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
            return (StdData)this.restTemplate.postForObject(uri, (Object)httpEntity, StdData.class, new Object[0]);
        }
        catch (HttpStatusCodeException e) {
            throw new ThirdCallException((ErrorHandler)CommonErrorCode.REMOTE_UNEXPECTED, uri, (Exception)((Object)e));
        }
        catch (Exception e) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.BUSINESS, e.getMessage());
        }
    }
}

