package com.digiwin.dap.middle.sql.safe.domain;

import java.util.*;
import java.util.stream.Collectors;

public class SqlRule {

    private final Map<SqlTable, SqlTableRule> tables = new HashMap<>();
    private final Set<String> functions = new HashSet<>();
    private final Set<String> withs = new HashSet<>();

    public SqlRule() {
    }

    public SqlRule table(SqlTable table, String... cols) {
        if (this.tables.containsKey(table)) {
            this.tables.get(table).columns(cols);
        } else {
            SqlTableRule SQLTableRule = new SqlTableRule();
            SQLTableRule.columns(cols);
            this.tables.put(table, SQLTableRule);
        }
        return this;
    }

    public SqlRule functions(String... funs) {
        this.functions.addAll(Arrays.stream(funs).map(String::toUpperCase).collect(Collectors.toList()));
        return this;
    }

    public SqlRule with(String with) {
        this.withs.add(with);
        return this;
    }

    public boolean containsTable(String db, String table) {
        return tables.containsKey(new SqlTable(db, table));
    }

    public boolean containsColumn(String db, String table, String column) {
        return tables.get(new SqlTable(db, table)).getColumns().contains(column.toLowerCase());
    }

    public boolean containsFunction(String function) {
        return functions.contains(function.toUpperCase());
    }

    public boolean containsWith(String with) {
        return withs.contains(with.toLowerCase());
    }

    @Override
    public String toString() {
        return "共 " + tables.size() + " 张表，" + functions.size() + " 个函数。";
    }
}
