/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.sql.safe.service;

import com.digiwin.dap.middle.sql.safe.domain.SqlRule;
import com.digiwin.dap.middle.sql.safe.domain.SqlTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;

public class SqlSafeValidator {
    private static final String SUBSELECT = "<SUBSELECT>";
    private static final Map<String, String> appDbMap = new HashMap<String, String>();
    private final String db;
    private final SqlRule sqlRule;

    private SqlSafeValidator(String appName, SqlRule sqlRule) {
        this.db = appDbMap.getOrDefault(appName, appName);
        this.sqlRule = sqlRule;
    }

    public static SqlSafeValidator build(String appName, SqlRule sqlRule) {
        return new SqlSafeValidator(appName, sqlRule);
    }

    public void validate(String sql) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (!(statement instanceof Select)) {
                throw new IllegalArgumentException("\u4ec5\u652f\u6301 SELECT \u8bed\u53e5");
            }
            Select select = (Select)statement;
            if (select.getWithItemsList() != null) {
                for (WithItem withItem : select.getWithItemsList()) {
                    this.sqlRule.with(withItem.getAliasName().toLowerCase());
                    ParenthesedSelect withBody = withItem.getSelect();
                    this.processFromItem((FromItem)withBody, "WITH \u5b50\u53e5 [" + withItem.getAliasName() + "]", 0);
                }
            }
            this.processFromItem((FromItem)select, "SELECT", 0);
        }
        catch (JSQLParserException e) {
            throw new IllegalArgumentException("SQL \u89e3\u6790\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private void processFromItem(FromItem fromItem, String context, int level) {
        if (fromItem instanceof LateralSubSelect) {
            this.validateSelectBody(((LateralSubSelect)fromItem).getSelect(), context, level + 1);
        } else if (fromItem instanceof ParenthesedSelect) {
            this.validateSelectBody(((ParenthesedSelect)fromItem).getSelect(), context, level + 1);
        } else if (fromItem instanceof Select) {
            this.validateSelectBody((Select)fromItem, context, level + 1);
        } else if (fromItem instanceof ParenthesedFromItem) {
            this.processFromItem(((ParenthesedFromItem)fromItem).getFromItem(), context, level + 1);
        }
    }

    protected void validateSelectBody(Select select, String context, int level) {
        if (select instanceof PlainSelect) {
            this.validatePlainSelect((PlainSelect)select, context);
        } else if (select.getWithItemsList() != null && !select.getWithItemsList().isEmpty()) {
            select.getWithItemsList().forEach(withItem -> {
                if (withItem.getSelect() != null) {
                    this.validateSelectBody((Select)withItem.getSelect(), context, level + 1);
                }
            });
        } else {
            SetOperationList operationList = (SetOperationList)select;
            if (operationList.getSelects() != null && !operationList.getSelects().isEmpty()) {
                List plainSelects = operationList.getSelects();
                for (Select plainSelect : plainSelects) {
                    this.validateSelectBody(plainSelect, context, level + 1);
                }
            }
        }
    }

    private void validatePlainSelect(PlainSelect select, String context) {
        Map<String, String> aliasTableMap = this.extractAliasTableMapping(select);
        List<String> fieldAliases = this.extractFiledAliases(select);
        for (SelectItem item : select.getSelectItems()) {
            if (item.getExpression() instanceof AllColumns) {
                throw new IllegalArgumentException("\u7981\u6b62\u4f7f\u7528 SELECT *(\u4f4d\u7f6e\uff1a" + context + ")");
            }
            this.validateExpression(item.getExpression(), aliasTableMap, fieldAliases, context + " \u5b57\u6bb5");
        }
        if (select.getWhere() != null) {
            this.validateExpression(select.getWhere(), aliasTableMap, fieldAliases, context + " WHERE");
        }
        if (select.getGroupBy() != null && select.getGroupBy().getGroupingSets() != null) {
            for (Expression expr : select.getGroupBy().getGroupingSets()) {
                this.validateExpression(expr, aliasTableMap, fieldAliases, context + " GROUP BY");
            }
        }
        if (select.getHaving() != null) {
            this.validateExpression(select.getHaving(), aliasTableMap, fieldAliases, context + " HAVING");
        }
        if (select.getOrderByElements() != null) {
            for (Expression expr : select.getOrderByElements()) {
                this.validateExpression(expr.getExpression(), aliasTableMap, fieldAliases, context + " ORDER BY");
            }
        }
        this.processFromItem(select.getFromItem(), context + " FROM \u5b50\u67e5\u8be2", 0);
        if (select.getJoins() != null) {
            for (Join join : select.getJoins()) {
                FromItem item = join.getRightItem();
                if (item instanceof Select) {
                    this.processFromItem(item, context + " JOIN \u5b50\u67e5\u8be2", 0);
                }
                for (Expression expr : join.getOnExpressions()) {
                    this.validateExpression(expr, aliasTableMap, fieldAliases, context + " JOIN ON");
                }
            }
        }
    }

    private void validateExpression(Expression expr, final Map<String, String> aliasTableMap, final List<String> fieldAliases, final String context) {
        expr.accept((ExpressionVisitor)new ExpressionVisitorAdapter<Void>(){

            public <S> Void visit(Column column, S ctx) {
                String actualTable;
                String tableAlias;
                String columnName = column.getColumnName();
                if ("FALSE".equalsIgnoreCase(columnName) || "TRUE".equalsIgnoreCase(columnName) || fieldAliases.contains(columnName)) {
                    return null;
                }
                String string = tableAlias = column.getTable() != null ? column.getTable().getName() : null;
                if (tableAlias != null) {
                    actualTable = (String)aliasTableMap.get(tableAlias);
                } else if (aliasTableMap.size() == 1) {
                    actualTable = (String)aliasTableMap.values().iterator().next();
                } else {
                    throw new IllegalArgumentException("\u591a\u8868\u67e5\u8be2\u65f6\uff0c\u5b57\u6bb5 [" + String.valueOf(column) + "] \u5fc5\u987b\u6307\u5b9a\u8868\u522b\u540d(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                if (SqlSafeValidator.SUBSELECT.equals(aliasTableMap.get(tableAlias)) || SqlSafeValidator.SUBSELECT.equals(actualTable)) {
                    return null;
                }
                if (actualTable == null) {
                    throw new IllegalArgumentException("\u5b57\u6bb5 [" + String.valueOf(column) + "] \u6240\u5c5e\u8868\u672a\u77e5(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                if (SqlSafeValidator.this.sqlRule.containsWith(actualTable)) {
                    return null;
                }
                if (!SqlSafeValidator.this.sqlRule.containsTable(SqlSafeValidator.this.db, actualTable)) {
                    throw new IllegalArgumentException("\u5b57\u6bb5 [" + String.valueOf(column) + "] \u6240\u5c5e\u8868 [" + String.valueOf(new SqlTable(SqlSafeValidator.this.db, actualTable)) + "] \u4e0d\u5728\u767d\u540d\u5355(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                if (!SqlSafeValidator.this.sqlRule.containsColumn(SqlSafeValidator.this.db, actualTable, columnName)) {
                    throw new IllegalArgumentException("\u5b57\u6bb5 [" + String.valueOf(column) + "] \u4e0d\u5728\u8868 [" + String.valueOf(new SqlTable(SqlSafeValidator.this.db, actualTable)) + "] \u7684\u767d\u540d\u5355\u4e2d(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                return null;
            }

            public <S> Void visit(Function function, S ctx) {
                String funcName = function.getName();
                if (funcName == null) {
                    return null;
                }
                if (!SqlSafeValidator.this.sqlRule.containsFunction(funcName)) {
                    throw new IllegalArgumentException("\u51fd\u6570 [" + funcName + "] \u4e0d\u5728\u5168\u5c40\u767d\u540d\u5355\u4e2d(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                if (function.getParameters() != null) {
                    for (Expression expr : function.getParameters()) {
                        if (expr instanceof AllColumns) {
                            expr.accept((ExpressionVisitor)this, (Object)funcName);
                            continue;
                        }
                        expr.accept((ExpressionVisitor)this, ctx);
                    }
                }
                return null;
            }

            public <S> Void visit(AllColumns function, S funcName) {
                if (funcName instanceof String && !"COUNT".equalsIgnoreCase((String)funcName)) {
                    throw new IllegalArgumentException("\u51fd\u6570 [" + String.valueOf(funcName) + "] \u4e0d\u5141\u8bb8\u4f7f\u7528 * \u53c2\u6570(\u4f4d\u7f6e\uff1a" + context + ")");
                }
                return null;
            }

            public void visit(AllColumns allColumns) {
                System.out.println("allColumns = " + String.valueOf(allColumns));
            }
        });
    }

    private List<String> extractFiledAliases(PlainSelect select) {
        ArrayList<String> aliases = new ArrayList<String>();
        for (SelectItem item : select.getSelectItems()) {
            Alias alias = item.getAlias();
            if (alias == null) continue;
            aliases.add(alias.getName().replaceAll("'", ""));
        }
        return aliases;
    }

    private Map<String, String> extractAliasTableMapping(PlainSelect select) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        this.processFromItem(select.getFromItem(), aliasMap);
        if (select.getJoins() != null) {
            for (Join join : select.getJoins()) {
                this.processFromItem(join.getRightItem(), aliasMap);
            }
        }
        return aliasMap;
    }

    private void processFromItem(FromItem item, Map<String, String> aliasMap) {
        if (item instanceof Table) {
            Table table = (Table)item;
            String normalizedName = this.normalizeTableName(table.getName());
            String alias = table.getAlias() != null ? table.getAlias().getName() : normalizedName;
            aliasMap.put(alias, normalizedName);
        } else if (item instanceof ParenthesedSelect) {
            String alias;
            ParenthesedSelect subSelect = (ParenthesedSelect)item;
            String string = alias = subSelect.getAlias() != null ? subSelect.getAlias().getName() : null;
            if (alias != null) {
                aliasMap.put(alias, SUBSELECT);
            }
        }
    }

    private String normalizeTableName(String name) {
        return name != null ? name.replaceAll("`", "") : null;
    }

    static {
        appDbMap.put("gmc", "omc");
        appDbMap.put("boss", "iam");
    }
}

