package com.digiwin.dap.middle.sql.safe.service;

import com.digiwin.dap.middle.sql.safe.domain.SqlRule;
import com.digiwin.dap.middle.sql.safe.domain.SqlTable;
import com.digiwin.dap.middle.sql.safe.domain.SqlWhiteList;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;

import java.util.List;

public class SqlWhitelistLoader {

    private static final String TABLE_PREFIX = "SQL_TABLE_";
    private static final String FUNCTION_PREFIX = "SQL_FUNCTION";

    public static SqlRule load(JdbcTemplate jdbcTemplate) {
        SqlRule sqlRule = new SqlRule();
        // 加载所有表和字段
        String tableSql = "SELECT id, content, remark FROM white_list WHERE id LIKE ?";
        List<SqlWhiteList> tablesWhiteList = jdbcTemplate.query(tableSql, new BeanPropertyRowMapper<>(SqlWhiteList.class), TABLE_PREFIX + "%");
        for (SqlWhiteList item : tablesWhiteList) {
            String table = item.getId().replace(TABLE_PREFIX, "").toLowerCase();
            if (StrUtils.isEmpty(item.getContent())) {
                sqlRule.table(new SqlTable(item.getRemark(), table));
            } else {
                String[] columns = item.getContent().split(";");
                sqlRule.table(new SqlTable(item.getRemark(), table), columns);
            }
        }

        // 加载函数白名单（只有一个，用List接不用处理null）
        String functionSql = "select id, content from white_list where id = ?";
        List<SqlWhiteList> functionWhiteList = jdbcTemplate.query(functionSql, new BeanPropertyRowMapper<>(SqlWhiteList.class), FUNCTION_PREFIX);
        for (SqlWhiteList item : functionWhiteList) {
            if (StrUtils.isNotEmpty(item.getContent())) {
                String[] functions = item.getContent().split(";");
                sqlRule.functions(functions);
            }
        }
        System.out.println("白名单规则加载完成：" + sqlRule);

        return sqlRule;
    }
}
