/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.sql.safe.service;

import java.util.ArrayList;
import java.util.Collections;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;

public class CountSqlBuilder {
    public static String buildCountSql(String sql) {
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (!(statement instanceof Select)) {
                throw new IllegalArgumentException("\u4ec5\u652f\u6301 SELECT \u8bed\u53e5");
            }
            Select select = (Select)statement;
            boolean hasPaging = CountSqlBuilder.hasPaging(select);
            if (!hasPaging) {
                return null;
            }
            CountSqlBuilder.removePagingAndOrdering(select);
            if (select instanceof SetOperationList) {
                return CountSqlBuilder.wrapCountSubSelect(select);
            }
            if (select instanceof PlainSelect) {
                PlainSelect ps = (PlainSelect)select;
                if (ps.getGroupBy() != null) {
                    return CountSqlBuilder.wrapCountSubSelect((Select)ps);
                }
                return CountSqlBuilder.buildSimpleCountSelect(ps);
            }
            return null;
        }
        catch (JSQLParserException e) {
            throw new IllegalArgumentException("SQL \u89e3\u6790\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private static boolean hasPaging(Select body) {
        if (body instanceof PlainSelect) {
            PlainSelect ps = (PlainSelect)body;
            return ps.getLimit() != null || ps.getOffset() != null || ps.getFetch() != null;
        }
        if (body instanceof SetOperationList) {
            SetOperationList set = (SetOperationList)body;
            return set.getLimit() != null || set.getOffset() != null || set.getFetch() != null;
        }
        return false;
    }

    private static void removePagingAndOrdering(Select body) {
        if (body instanceof PlainSelect) {
            PlainSelect ps = (PlainSelect)body;
            ps.setLimit(null);
            ps.setOffset(null);
            ps.setFetch(null);
            ps.setOrderByElements(null);
        } else if (body instanceof SetOperationList) {
            SetOperationList set = (SetOperationList)body;
            set.setLimit(null);
            set.setOffset(null);
            set.setFetch(null);
            set.setOrderByElements(null);
        }
    }

    private static String wrapCountSubSelect(Select select) {
        ParenthesedSelect subSelect = new ParenthesedSelect();
        subSelect.setSelect(select);
        subSelect.setAlias(new Alias("tmp_count"));
        PlainSelect countSelect = new PlainSelect();
        countSelect.setFromItem((FromItem)subSelect);
        countSelect.setSelectItems(Collections.singletonList(new SelectItem((Expression)new Column("COUNT(*)"))));
        if (select.getWithItemsList() != null) {
            countSelect.setWithItemsList(select.getWithItemsList());
            select.setWithItemsList(null);
        }
        return countSelect.toString();
    }

    private static String buildSimpleCountSelect(PlainSelect select) {
        ArrayList<SelectItem> COUNT_ITEM = new ArrayList<SelectItem>();
        COUNT_ITEM.add(new SelectItem((Expression)new Column("COUNT(*)")));
        select.setSelectItems(COUNT_ITEM);
        return select.toString();
    }
}

