/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.sql.safe.service;

import com.digiwin.dap.middle.sql.safe.domain.SqlRule;
import com.digiwin.dap.middle.sql.safe.domain.SqlTable;
import com.digiwin.dap.middle.sql.safe.domain.SqlWhiteList;
import com.digiwin.dap.middleware.commons.util.StrUtils;
import java.util.List;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class SqlWhitelistLoader {
    private static final String TABLE_PREFIX = "SQL_TABLE_";
    private static final String FUNCTION_PREFIX = "SQL_FUNCTION";

    public static SqlRule load(JdbcTemplate jdbcTemplate) {
        SqlRule sqlRule = new SqlRule();
        String tableSql = "SELECT id, content, remark FROM white_list WHERE id LIKE ?";
        List tablesWhiteList = jdbcTemplate.query(tableSql, (RowMapper)new BeanPropertyRowMapper(SqlWhiteList.class), new Object[]{"SQL_TABLE_%"});
        for (SqlWhiteList item : tablesWhiteList) {
            String table = item.getId().replace(TABLE_PREFIX, "").toLowerCase();
            if (StrUtils.isEmpty((String)item.getContent())) {
                sqlRule.table(new SqlTable(item.getRemark(), table), new String[0]);
                continue;
            }
            String[] columns = item.getContent().split(";");
            sqlRule.table(new SqlTable(item.getRemark(), table), columns);
        }
        String functionSql = "select id, content from white_list where id = ?";
        List functionWhiteList = jdbcTemplate.query(functionSql, (RowMapper)new BeanPropertyRowMapper(SqlWhiteList.class), new Object[]{FUNCTION_PREFIX});
        for (SqlWhiteList item : functionWhiteList) {
            if (!StrUtils.isNotEmpty((String)item.getContent())) continue;
            String[] functions = item.getContent().split(";");
            sqlRule.functions(functions);
        }
        System.out.println("\u767d\u540d\u5355\u89c4\u5219\u52a0\u8f7d\u5b8c\u6210\uff1a" + String.valueOf(sqlRule));
        return sqlRule;
    }
}

