package com.digiwin.dap.middle.sql.safe.domain;

import java.util.Objects;

public class SqlTable {

    private String db;
    private String table;

    public SqlTable() {
    }

    public SqlTable(String table) {
        this.table = table.toLowerCase();
    }

    public SqlTable(String db, String table) {
        this.db = db == null ? null : db.toLowerCase();
        this.table = table.toLowerCase();
    }

    public String getDb() {
        return db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getTable() {
        return table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || getClass() != o.getClass()) return false;
        SqlTable sqlTable = (SqlTable) o;
        return Objects.equals(db, sqlTable.db) && Objects.equals(table, sqlTable.table);
    }

    @Override
    public int hashCode() {
        return Objects.hash(db, table);
    }

    @Override
    public String toString() {
        return db != null ? db + "." + table : table;
    }
}