package com.digiwin.dap.middle.tx.stream.schedule;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.tx.stream.entity.TransactionMessage;
import com.digiwin.dap.middle.tx.stream.producer.TxProducerService;
import com.digiwin.dap.middle.tx.stream.service.TransactionMessageService;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class TransactionMessageSchedule {

    private static final Logger logger = LoggerFactory.getLogger(TransactionMessageSchedule.class);

    private static final int PAGE_SIZE = 100;

    @Autowired
    private TransactionMessageService transactionMessageService;

    @Autowired
    private TxProducerService txProducerService;

    @Scheduled(fixedDelay = 1000)
    public void scheduleMessage() {
        try {
            while (true) {
                List<TransactionMessage> txMessages = transactionMessageService.selectPendingTransactionMessage(PAGE_SIZE);
                if (CollectionUtils.isEmpty(txMessages)) {
                    return;
                }
                for (TransactionMessage txMessage : txMessages) {
                    int update = transactionMessageService.updateTransactionMessageStatusToSending(txMessage.getSid());
                    if (update < 1) {
                        continue;
                    }
                    MessageBody messageBody = JsonUtils.jsonToObj(txMessage.getContent(), MessageBody.class);
                    txProducerService.internal(messageBody);
                    transactionMessageService.deleteTransactionMessage(txMessage.getSid());
                }
            }
        } catch (Exception e) {
            logger.error("scheduleTransactionMessage error", e);
        }
    }
}
