/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.tx.stream.schedule;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.tx.stream.entity.TransactionMessage;
import com.digiwin.dap.middle.tx.stream.producer.TxProducerService;
import com.digiwin.dap.middle.tx.stream.service.TransactionMessageService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class TransactionMessageSchedule {
    private static final Logger logger = LoggerFactory.getLogger(TransactionMessageSchedule.class);
    private static final int PAGE_SIZE = 100;
    @Autowired
    private TransactionMessageService transactionMessageService;
    @Autowired
    private TxProducerService txProducerService;

    @Scheduled(fixedDelay=1000L)
    public void scheduleMessage() {
        try {
            block2: while (true) {
                List<TransactionMessage> txMessages;
                if (CollectionUtils.isEmpty(txMessages = this.transactionMessageService.selectPendingTransactionMessage(100))) {
                    return;
                }
                Iterator<TransactionMessage> iterator = txMessages.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block2;
                    TransactionMessage txMessage = iterator.next();
                    int update = this.transactionMessageService.updateTransactionMessageStatusToSending(txMessage.getSid());
                    if (update < 1) continue;
                    MessageBody messageBody = (MessageBody)JsonUtils.jsonToObj((String)txMessage.getContent(), MessageBody.class);
                    this.txProducerService.internal(messageBody);
                    this.transactionMessageService.deleteTransactionMessage(txMessage.getSid());
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("scheduleTransactionMessage error", (Throwable)e);
            return;
        }
    }
}

