/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.tx.stream.producer;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.MessageType;
import com.digiwin.dap.middle.stream.producer.channel.InternalOutput;
import com.digiwin.dap.middle.tx.stream.domain.TxMessageStatus;
import com.digiwin.dap.middle.tx.stream.entity.TransactionMessage;
import com.digiwin.dap.middle.tx.stream.producer.TxProducerService;
import com.digiwin.dap.middle.tx.stream.service.TransactionMessageService;
import com.digiwin.dap.middleware.constant.DapHttpHeaders;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.stereotype.Service;

@Service
public class TxProducerServiceImpl
implements TxProducerService {
    @Autowired
    private DapEnv dapEnv;
    @Autowired(required=false)
    private InternalOutput internalChannel;
    @Autowired
    private TransactionMessageService transactionMessageService;

    @Override
    public void internal(MessageBody messageInfo) {
        this.internal(messageInfo, false);
    }

    @Override
    public void internal(MessageBody messageInfo, boolean transaction) {
        this.internal(messageInfo, transaction, LocalDateTime.now());
    }

    @Override
    public void internal(MessageBody messageBody, boolean transaction, LocalDateTime sendTime) {
        String payload;
        messageBody.setSourceId(this.dapEnv.getAppName());
        messageBody.setMsgType(MessageType.INTERNAL);
        if (messageBody.getUserToken() == null) {
            messageBody.setUserToken(UserUtils.getToken());
        }
        if ((payload = JsonUtils.writeValue((Object)messageBody)) == null) {
            return;
        }
        MessageBuilder builder = MessageBuilder.withPayload((Object)payload).setHeader(DapHttpHeaders.MESSAGE_EVENT_ID.getHeader(), (Object)messageBody.getOpType()).setHeader(DapHttpHeaders.USER_TOKEN.getHeader(), (Object)messageBody.getUserToken()).setHeader(DapHttpHeaders.APP_TOKEN.getHeader(), (Object)"eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE1MzczMjY2ODk0NjEsInNpZCI6NDA3MTI4ODI1NTM0NDY0MSwiaWQiOiJEaWdpd2luQ2xvdWQifQ.XGPl3brNeNTCivWN_bIYj8TfcxqlkQ0sFV2woPOr0TY").setHeader(DapHttpHeaders.ACCEPT_LANGUAGE.getHeader(), (Object)LocaleContextHolder.getLocale().toLanguageTag()).setHeader("userId", (Object)UserUtils.getUserId()).setHeader("tenantId", (Object)UserUtils.getTenantId());
        Optional.ofNullable(messageBody.getHeaderTag()).filter(tag -> !tag.isEmpty()).ifPresent(tag -> builder.setHeader("tag", tag));
        Message message = builder.build();
        if (transaction) {
            TransactionMessage txMessage = new TransactionMessage();
            txMessage.setContent(JsonUtils.objToJson((Object)messageBody));
            txMessage.setStatus(TxMessageStatus.PENDING.name());
            txMessage.setSendTime(sendTime);
            txMessage.setRetryCount(0);
            this.transactionMessageService.insertTransactionMessage(txMessage);
        } else {
            this.internalChannel.internal().send(message);
        }
    }
}

