/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middle.tx.stream.schedule;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.tx.stream.entity.TransactionMessage;
import com.digiwin.dap.middle.tx.stream.producer.TxProducerService;
import com.digiwin.dap.middle.tx.stream.service.TransactionMessageService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@ConditionalOnProperty(name={"dap.middleware.stream.tx-task"}, havingValue="true", matchIfMissing=true)
@Service
public class TransactionMessageSchedule {
    private static final Logger logger = LoggerFactory.getLogger(TransactionMessageSchedule.class);
    private static final int PAGE_SIZE = 100;
    private static final int MAX_RETRY_COUNT = 3;
    @Autowired
    private TransactionMessageService transactionMessageService;
    @Autowired
    private TxProducerService txProducerService;

    @Scheduled(fixedDelay=1000L)
    public void scheduleMessage() {
        try {
            block4: while (true) {
                List<TransactionMessage> txMessages;
                if (CollectionUtils.isEmpty(txMessages = this.transactionMessageService.selectPendingTransactionMessage(100, 3))) {
                    return;
                }
                Iterator<TransactionMessage> iterator = txMessages.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block4;
                    TransactionMessage txMessage = iterator.next();
                    int update = this.transactionMessageService.updateTransactionMessageStatusToSending(txMessage.getSid());
                    if (update < 1) continue;
                    try {
                        MessageBody messageBody = (MessageBody)JsonUtils.jsonToObj((String)txMessage.getContent(), MessageBody.class);
                        this.txProducerService.internal(messageBody);
                    }
                    catch (Exception e) {
                        logger.error("scheduleTransactionMessage error", (Throwable)e);
                        this.transactionMessageService.updateTransactionMessageStatusToPending(txMessage.getSid(), LocalDateTime.now().plusSeconds(5L));
                        continue;
                    }
                    this.transactionMessageService.deleteTransactionMessage(txMessage.getSid());
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("scheduleTransactionMessage error", (Throwable)e);
            return;
        }
    }
}

